/*---------------------------------------------*\
|  Color Nokia LCD Text Library					|
| This library contains a small 6x8 bitmap font |
| that can be used to write text on graphic LCD	|
| displays such as the common Nokia 132x132 	|
| screen.  The stock code is designed for the	|
| Philips controller though should be easily	|
| modified for other graphic LCD's.				|
|												|
| Adam Honse (CalcProgrammer1) 3-17-2011		|
\*---------------------------------------------*/

#include "color_lcd_text.h"


//This is a small 6x8 font.  Each line (6 bytes) represents a single character.  Each byte
//represents one column, LSB is the top of the line and MSB is the bottom.  The bytes are 
//arranged from left to right in groups of 6.  To calculate the array starting value from
//ASCII, use the formula awesome_font[(text-32)*6].
const char awesome_font[] PROGMEM = {	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,		//32 ( )
										0x00,	0x5F,	0x00,	0x00,	0x00,	0x00,		//33 (!)
										0x07,	0x00,	0x07,	0x00,	0x00,	0x00,		//34 (")
										0x14,	0x7F,	0x14,	0x7F,	0x14,	0x00,		//35 (#)
										0x26,	0x49,	0x7F,	0x49,	0x32,	0x00,		//36 ($)
										0x42,	0x25,	0x12,	0x48,	0xA4,	0x42,		//37 (%)
										0x36,	0x49,	0x56,	0x20,	0x50,	0x00,		//38 (&)
										0x04,	0x03,	0x00,	0x00,	0x00,	0x00,		//39 (')
										0x1C,	0x22,	0x41,	0x00,	0x00,	0x00,		//40 (()
										0x41,	0x22,	0x1C,	0x00,	0x00,	0x00,		//41 ())
										0x00,	0x05,	0x02,	0x05,	0x00,	0x00,		//42 (*)
										0x08,	0x08,	0x3E,	0x08,	0x08,	0x00,		//43 (+)
										0x80,	0x60,	0x00,	0x00,	0x00,	0x00,		//44 (,)
										0x08,	0x08,	0x08,	0x08,	0x08,	0x08,		//45 (-)
										0x00,	0x40,	0x00,	0x00,	0x00,	0x00,		//46 (.)
										0x40,	0x20,	0x10,	0x08,	0x04,	0x02,		//47 (/)
										0x3E,	0x41,	0x41,	0x41,	0x3E,	0x00,		//48 (0)
										0x00,	0x42,	0x7F,	0x40,	0x00,	0x00,		//49 (1)
										0x62,	0x51,	0x49,	0x49,	0x46,	0x00,		//50 (2)
										0x22,	0x41,	0x49,	0x49,	0x36,	0x00,		//51 (3)
										0x18,	0x14,	0x12,	0x7F,	0x10,	0x00,		//52 (4)
										0x27,	0x49,	0x49,	0x49,	0x31,	0x00,		//53 (5)
										0x3C,	0x4A,	0x49,	0x49,	0x30,	0x00,		//54 (6)
										0x01,	0x71,	0x09,	0x05,	0x03,	0x00,		//55 (7)
										0x36,	0x49,	0x49,	0x49,	0x36,	0x00,		//56 (8)
										0x06,	0x49,	0x49,	0x29,	0x1E,	0x00,		//57 (9)
										0x00,	0x14,	0x00,	0x00,	0x00,	0x00,		//58 (:)
										0x80,	0x68,	0x00,	0x00,	0x00,	0x00,		//59 (;)
										0x08,	0x14,	0x22,	0x41,	0x00,	0x00,		//60 (<)
										0x14,	0x14,	0x14,	0x14,	0x00,	0x00,		//61 (=)
										0x41,	0x22,	0x14,	0x08,	0x00,	0x00,		//62 (>)
										0x02,	0x01,	0x51,	0x09,	0x06,	0x00,		//63 (?)
										0x3E,	0x41,	0x5D,	0x55,	0x4E,	0x00,		//64 (@)
										0x7C,	0x12,	0x11,	0x12,	0x7C,	0x00,		//65 (A)
										0x7F,	0x49,	0x49,	0x49,	0x36,	0x00,		//66 (B)
										0x3E,	0x41,	0x41,	0x41,	0x22,	0x00,		//67 (C)
										0x7F,	0x41,	0x41,	0x22,	0x1C,	0x00,		//68 (D)
										0x7F,	0x49,	0x49,	0x49,	0x41,	0x00,		//69 (E)
										0x7F,	0x09,	0x09,	0x09,	0x01,	0x00,		//70 (F)
										0x3E,	0x41,	0x41,	0x51,	0x72,	0x00,		//71 (G)
										0x7F,	0x08,	0x08,	0x08,	0x7F,	0x00,		//72 (H)
										0x41,	0x7F,	0x41,	0x00,	0x00,	0x00,		//73 (I)
										0x20,	0x40,	0x41,	0x3F,	0x01,	0x00,		//74 (J)
										0x7F,	0x08,	0x14,	0x22,	0x41,	0x00,		//75 (K)
										0x7F,	0x40,	0x40,	0x40,	0x00,	0x00,		//76 (L)
										0x7F,	0x02,	0x0C,	0x02,	0x7F,	0x00,		//77 (M)
										0x7F,	0x06,	0x08,	0x30,	0x7F,	0x00,		//78 (N)
										0x1C,	0x22,	0x41,	0x41,	0x22,	0x1C,		//79 (O)
										0x7F,	0x09,	0x09,	0x09,	0x06,	0x00,		//80 (P)
										0x3E,	0x41,	0x51,	0x21,	0x5E,	0x00,		//81 (Q)
										0x7F,	0x09,	0x19,	0x29,	0x46,	0x00,		//82 (R)
										0x26,	0x49,	0x49,	0x49,	0x32,	0x00,		//83 (S)
										0x01,	0x01,	0x7F,	0x01,	0x01,	0x00,		//84 (T)
										0x3F,	0x40,	0x40,	0x40,	0x3F,	0x00,		//85 (U)
										0x0F,	0x30,	0x40,	0x30,	0x0F,	0x00,		//86 (V)
										0x3F,	0x40,	0x38,	0x40,	0x3F,	0x00,		//87 (W)
										0x63,	0x14,	0x08,	0x14,	0x63,	0x00,		//88 (X)
										0x07,	0x08,	0x70,	0x08,	0x07,	0x00,		//89 (Y)
										0x61,	0x51,	0x49,	0x45,	0x43,	0x00,		//90 (Z)
										0x7F,	0x41,	0x41,	0x00,	0x00,	0x00,		//91 ([)
										0x02,	0x04,	0x08,	0x10,	0x20,	0x40,		//92 (\)
										0x41,	0x41,	0x7F,	0x00,	0x00,	0x00,		//93 (])
										0x08,	0x04,	0x02,	0x04,	0x08,	0x00,		//94 (^)
										0x40,	0x40,	0x40,	0x40,	0x40,	0x00,		//95 (_)
										0x03,	0x04,	0x00,	0x00,	0x00,	0x00,		//96 (`)
										0x20,	0x54,	0x54,	0x78,	0x00,	0x00,		//97 (a)
										0x7F,	0x28,	0x44,	0x44,	0x38,	0x00,		//98 (b)
										0x38,	0x44,	0x44,	0x28,	0x00,	0x00,		//99 (c)
										0x38,	0x44,	0x44,	0x28,	0x7F,	0x00,		//100 (d)
										0x38,	0x54,	0x54,	0x48,	0x00,	0x00,		//101 (e)
										0x08,	0x7E,	0x09,	0x02,	0x00,	0x00,		//102 (f)
										0x98,	0xA4,	0xA4,	0x58,	0x00,	0x00,		//103 (g)
										0x7F,	0x08,	0x04,	0x04,	0x78,	0x00,		//104 (h)
										0x3D,	0x40,	0x00,	0x00,	0x00,	0x00,		//105 (i)
										0x80,	0x84,	0x7D,	0x00,	0x00,	0x00,		//106 (j)
										0x7F,	0x10,	0x28,	0x44,	0x00,	0x00,		//107 (k)
										0x01,	0x7F,	0x00,	0x00,	0x00,	0x00,		//108 (l)
										0x78,	0x04,	0x78,	0x04,	0x78,	0x00,		//109 (m)
										0x7C,	0x08,	0x04,	0x04,	0x78,	0x00,		//110 (n)
										0x38,	0x44,	0x44,	0x38,	0x00,	0x00,		//111 (o)
										0xFC,	0x18,	0x24,	0x24,	0x18,	0x00,		//112 (p)
										0x18,	0x24,	0x24,	0x18,	0xFC,	0x00,		//113 (q)
										0x7C,	0x08,	0x04,	0x04,	0x08,	0x00,		//114 (r)
										0x48,	0x54,	0x54,	0x24,	0x00,	0x00,		//115 (s)
										0x04,	0x3E,	0x44,	0x00,	0x00,	0x00,		//116 (t)
										0x3C,	0x40,	0x40,	0x20,	0x7C,	0x00,		//117 (u)
										0x1C,	0x20,	0x40,	0x20,	0x1C,	0x00,		//118 (v)
										0x3C,	0x40,	0x30,	0x40,	0x3C,	0x00,		//119 (w)
										0x44,	0x28,	0x10,	0x28,	0x44,	0x00,		//120 (x)
										0x1C,	0xA0,	0xA0,	0x7C,	0x00,	0x00,		//121 (y)
										0x64,	0x54,	0x54,	0x4C,	0x00,	0x00,		//122 (z)
										0x08,	0x36,	0x41,	0x00,	0x00,	0x00,		//123 ({)
										0x00,	0x7F,	0x00,	0x00,	0x00,	0x00,		//124 (|)
										0x41,	0x36,	0x08,	0x00,	0x00,	0x00,		//125 (})
										0x04,	0x02,	0x04,	0x02,	0x00,	0x00};		//126 (~)



								
void color_lcd_print_char(char text, int color, unsigned char x, unsigned char y)
{
	if((text > 31)&&(text < 127))
	{
		unsigned char current_x = x;
		unsigned char current_y = y;
		char current_byte;
		for(char i = 0; i < 6; i++)
		{
			current_byte = pgm_read_byte(&awesome_font[((text-32)*6)+i]);
			for(char pos = 0; pos < 8; pos++)
			{
				if(((current_byte>>pos) & 0x01)==0x01)
				{
					color_lcd_set_pixel(color,current_x,current_y);
				}
				current_y++;
			}
			current_y=y;
			current_x++;
		}
	}
}

void color_lcd_print_string(char * text, char length, int color, unsigned char x, unsigned char y)
{
	char i = 0;
	while((text[i] != '\0')&&(i<length))
	{
		color_lcd_print_char(text[i], color, x+i*6, y);
		i++;
	}
}
